<?php

namespace App\Models;

use CodeIgniter\Model;

class UserModel extends Model
{
    protected $table = 'users';
    protected $primaryKey = 'id';
    protected $allowedFields = ['username', 'password', 'role'];

    // Fungsi untuk cek login
    public function checkLogin($username, $password)
    {
        $user = $this->where('username', $username)->first();

        if ($user) {
            // Contoh sederhana untuk verifikasi password
            if (password_verify($password, $user['password'])) {
                return $user;
            }
        }
        return null;
    }
}
